//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////



module FPGA_i2c (
    input           clk,     // controller clock
    input           rst,     // synchronous active high reset
    input           nReset,  // asynchronous active low reset
    input           ena,     // core enable signal
    input [31:0]    i2c_scl_timeout,
    input [15:0]    clk_cnt,        // 4x SCL (default)

    // control inputs
    input       start,
    input       stop,
    input       read,
    input       write,
    input       ack_stretch,
    input       ack_in,
    input [7:0] din,

    // status outputs
    output logic      ack_out,
    output       cmd_ack,
    output       i2c_busy,
    output       i2c_al,
    output       idle,
    output [7:0] dout,

    // I2C signals
    input  scl_i,
    output scl_o,
    output scl_oen,
    input  sda_i,
    output sda_o,
    output sda_oen
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
PDDjSl/cZJ8s05xaqo7oq/fP9RyHQ4PvraphoVW3FGdbwi2c9rpTGTpmhpQsY81t
0YlqWKh4g+1KfBydMYoZXvIXmmcQsrnYXx1S2fPaR0nGEb1dHMk7Dm6fR2x9I7hQ
nw9i1tZTka+MO72d9DWpCRp66CIvMzSMLaUWgObr+ggXAwdGYraJFSQl+PU7zIPQ
p0ZibTfVLL61vMP68UdzYN7kF6Sb3j22RnKZyuwvFjxZzjvqzdBvYO6cgf0BID1a
kXSCqlvh1TdQt/WoH985Fv63J+1QXNuuqadCEjPkGWSGvs9OizW+FHTV4Vaq9tRs
ixH+MWuc+7nXOPXzg5BLjQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
25E/tNjF9DN6r6wtKOhv8/tJAo3/WBtq9UvPUrJclsp8ivGeFPBhsTwdvv6x37Yr
hsQBiHyudKC1Jf9Hossv8Yz0C2NKP1MOOLvBu6WpgJrJr9AEkNKuUXYtGOfEsVb1
QvuUTf6CTQQ7DwECDHaPr2dK9pYMtIUFcL1JK08+gR8=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
hpHEYxKCke9dcCdTkgg6OJfHw2STQFIgjyKBOi/NeWH3kJ7C6VIrMqb8Rqzku67H
fcFuqF8B4PJZjM4zCR8tDcFL1iTh0De3ruP4izHX4/m9K3CGPgPslKT00jE3OilW
Z1umAS+ix45AZijshwSiYWkecsZjRY37dOxaPAzx0dSED7W+tFCYtFd3ZjWWT+Hs
F/i2VYoQMD2aUhapV6855eahcEhE+Qd3e4ugJnYHYKNeTG7fYJSMUsNovn65W2/l
sXko4vmpwU+WJz7WGSohkxBQLXxawf6haJEjQOpIHHggVdXeqH0g8QalBSbMyOrh
f8ihVHiEOV1Ygnd2DeK8/g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
cYkRPoPKLn+mmO0tX7QH29dZMeWpSFsyMVN6dbSpKgoH8NN53Zrs211Pr7PMfZSt
QCEfA3ieEzS4z4dv7lpNhr+bboPitshh4Ot326Ycy0Yeg5oopoAXAx9lC3+VeMNX
drqFzVZtjmhMVZMHypfol2Rc5Chhnc9x0lG2IH5Ap3fBnGad3fnWStIsPPCrMaJr
nlHFj0tgMILxspzV74dP4HaxS+zceQD/gS5OWb3CPYFtiUUAVFrdACUo3BXmSx8V
VRMguiVXOQQDzE7auOvJJoTLihleIVbG0Ccj9Zxviqvx/ZTRGPK5lbqHt9dne6YN
P7lfOajpGbbuQYIG4hPfpQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
QxR9zHrgKA/nGFKbFXbpOtpg80CHmfU/eR+NXS2xR0joF3vIMAYVeZKLr5atqZRk
ox/znhUPaadsZed9b3IAMP2Ls0Ypm7NTdnNt61pK94Ylc4KrdImUpSuCZXe/baaK
CO5wyF1u8KtyPda1YUmmWVQoWIUlxs3De90pN6EPFjZGUbn0EPUoo/R6I6GVr6yb
mdRbRtJCqw7SXIFbpCv9Q1fqBdlBZhQ1LHrhi4PpARG7a7nIdPWIf9NoE3SX9GiH
VTQhLPVez7wK0hQYBzjH+S3F9W7sEakc3mBsDreLKureuCCPAvEbxn5amJG/C3+6
X9ob2WNoj6lluH6+2MsoDg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
izYU7w1fw8EmwOR+qU+S6tGGXKFRWdwoetoWNVr6zHl3RWb251JnWZ2NfQ2HZqu8
8STIfLy2A+1jqBPUc1/iDc2VYTfyqOLTKTgy5l0zSDLBYgN/Or87SeTf+X9NfzSu
XX4/dhfrdkAeNpbH7m5vuUmQPIlhalVXRFZW3/EqV849x0dwBrl2aWPQs5Kp51Sb
56rD1UlZHZYtY6TRzXGJx4pDQlDXC7NDnd4oLGuQzy8hFNxjVJPBgOsOL25dftYV
aN+7OaSSutNO+NS4txA7w10NrGT8Q69ffVbIhCv3rPk2UiN4XYoQiWHQe/uDdyvg
hcpRx7znYN0iJJi7JlRXOA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
dFcvJuMK770LFRNlHwS+F1ifFeaKHTPV/hwB84I1tzCxFku18OoPlMJ87Npyc84Y
NOoZ0lBDrZRTOWlKMqfZS1NzfD8Xc04QRP3DZbQv5k/1dvKAI5u6m/2klpuQFxoW
v8m0ratHFDd4lSKJn4pTk3MrrRe6WcYKdEhS1wJPDQDtyh3sR0f47bwUlqr+LvlU
JAggJLGbwik6C9BuQuKBODcVXhU/suWD0dvHCUR0BCn/cIjHwUjV3mX6ksPCuM2P
fqujs/dFjW4dr10LMZ7qo90oOcnbGvzy2RBxCFbUkrq86KqESgkj69XXoXjGJJyJ
w/4dyskv4CKOOQFv3HkAGslWX0J6l2huLRgn0Vpn9D0UxAlkcXT8x9KGgZ1rBt89
p4m/TjcqRgDPQlG3oWtTIB1OCOYepBHxwvznfrS6s2qPeC53MWZDqOAYFGzTJTcZ
994/pvVw6K21MNRaS4IBv10qodij+x4o4ydQnnhw2hyYPR9/etg6PT5EKieJyDl+
h0wd8BWtSX9OM3EjOekY4IMsZrVzEg86YNluGWePDujqaw4Ij4hstr5xDACypk4C
eQ+C7vWwBhNSbM6w6weshepm3RBfKLBwC7u5zYiKzEZPi8ow2EABRu5z1M+gAjGL
6HWJo6yMKJflPqfmn9aEZEvOV6o09pdpHGZdoioG1nD/EHkrX/lwU2tBwwaTywUN
8Rz2qpJYuiQ7GpcgqhWPbeHWGQcsPewBoRrq0EwTbhEOciPTIpf+2LRYuEIanCIr
ERZaiH74jXPeW7CxjF+4U1YW+SATUySgl7f6KV+3pe2EPH5BhSjFhAxN6+zxUoJt
1do8RkAgGeVAPGyYEWC6gYOuqfc4OkBR8xPapm0t7YiP0DC9oDPUQTqxSSBHPnhr
qvPhsbUyhVMyuaL6ozk5pcDDQsN06HnPIyx5zVKUC18w7eztsXej7OuLm/pKs8Hy
+P2RGgMOmkTZD7yL1/jOG4Q1QCI5ni3WPmt8TD7S1jQ8ruVSU6uPGOPuykpW2pTP
CkCSc+oOLs71U0uU2RrcQ3wk3ILFAcnRfItkl6mM64zbtnRo6ScUDyiY9u4y9ijn
YIWP0rgwzjBtqjZK9Rtb9IXmU83GzHxN+BkpSLRJP6FSehTspzw0YN9CNHLYdTdm
cqr3k16pJoOpPgmTjrJhoBUeBve0m/ArWWL3km71HiWm6lMzmGiVquzLp8+Ot7iH
p+bktF9QuAtGNGGvcjoM+WV8awf+5VCUp6kBuCBFms87udWPkG8Q2oUC810Ry+cq

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
fl76vKsiTuUh1UvMsdmvKmez3Eum42GBbwIu9DeSQhCeWl7FlGs+7GMOIg/iL+Fb
Pdan0GwfobckKq8X+8BdhZO9SpjXGqk2nCCfGwwEiwIKlfNMuLXUmhK0Ku/cMVjc
5/MSRKvCiMS/wh+uBdmfnB6v4VRJjZMgqETSDfr+Ls4=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=7664)
`pragma protect data_block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`pragma protect end_protected

endmodule
