//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module glb_ctrl_top
  import apb_pkg::*;
  import regmap_pkg::*;
#(
  parameter              N_GPIO = 16,
  parameter [N_GPIO-1:0] GPIO_RST_VAL = '0
)(
  // clock and reset
  input               i_pclk,     // async applied sync released reset
  input               i_prst,     // active high async reset
  // Register Map, abp clk domain
  input               i_aclk,
  input               i_arst,
  input  apb_m2s      i_apb_m2s,
  output apb_s2m      o_apb_s2m,
  // HOLOLINK GPIO control and status
  input  [31      :0] i_hsb_ver,
  input  [31      :0] i_hsb_date,
  input  [31      :0] i_hsb_stat,
  output [63      :0] o_hsb_ctrl,
  // User GPIO
  input  [N_GPIO-1:0] i_gpio,
  output [N_GPIO-1:0] o_gpio
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
UB4ia90b252gE6/+ipu+zdButt8FvCWGZFYmpNyTjUKi9Z/yDI1u5nVMSC8OBr2X
YZUfv1hsvdgNJuOzSgsGbUFr1mOKrulRuhqdFf472VwbgAEH1jjj6zofE4cHRMo+
a/VmunoFYuFXSxDRFw+zSUcjrARo8/bLFUrHxCRQBa25uwYISR123+hKg2yugOzd
mOXOpKBhcr5myKp5TBouW5VEoPOj2HuaBsksjX11jEXVYqwgVlZsr0K+HjSfPfqQ
vgd02zP9IB+nef24ZfdFaoyR87pvVuQsOArGZK9YsVRosbGaQVEIz0mxVHrgyHRp
s1o7HV5ilaDyu589dKPxKQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
X8H1gmVd0x6WOD7VvFEowgCY5/p1svgKxtPMdWZZqEfMx1vx9W1dXNW5+SibZWY3
xW1oOoiC4L0YmuaUNWKp+Q8O8Xhk7BM/G3mEpSIb3KpRosFaL8GzOzMifZzTl4YZ
iVrlQfb1+gD4uxgAxs8ZK8BlWV9SbpJcOSacC1KprF8=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
AtasdxerNuIuZ838lkMTsq065KaUnS9OI+30MlTuI9ooxT804VsuJM0VGhRugQr2
1DAVHeG3sncadmxQiWG1wL00WNbnviK1oGvBgBtnoFVq1lz/3QxqMniElThOOZ2g
AG8EUwYTmINfQHmGpwnXjBlCreDqZgJ59QVO95zIdxQK5rIFo51/KYXCJJfsGeKU
EKySUeDIIZ6QwSdQvWh9roNpUEV1kMiI2WvUDl1gzi+wcLVKdQBPg5l3mF2WwmsO
0EOyMry3NlclJh+3u8QZGxffV3wMPQAHxJ+sECovpQQ/f9BBg8v2Qlmi4um59gff
Z9Tp6aWeouEkS1oBreeNGQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
nNY4SsKMKrlqIPYFiTJgbLF0YJPIo/6jHuAGnmUHzddtQVZ+QkX4jIherLbkSKO9
ds+JhZaAy+7GOoBRTy/SoiPsnBcgLe/pMm8B9CmcPCepWOeBi7xOpf/lpAfj5Yax
9pSq6/ysYz2zvbxVmydFJiGXe8OewhY+WULnspU2HzJ2M4B07FJCTIcvWtNGxzoa
Uq13ECN/ahBovhNM9uwl8KmxfmW1V8H31jEHFnubDIoLbQCSB9N/4dmJdYWCwl/O
GJ1aJzjKHTlLIPOTofarvJlMWaNDPGF7NE/hhP76CkgU+V5yqwXypLfjB7zz/SP+
360XSRmKc1QYZ/5V9inI2A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
Ux31eq5+TxOmmv5hRzShB5SOG1piEGagToeuNYSIsv1Z6w79BYosp4f/aLi5HYcW
GhR9+vksHtnyonRuBcXLfrM3nCX1Ukp91QxFbRiDRTLoW/Y0z/CZSyZZ6PUgYP6t
e1qK5ZVtu/1mgV8Nkzf3sjFJL9UBZLGaQPYLx44o6AisYUPRqJ2Syy88tNsxVoE4
IeXEyFoK8mpAmeQFl6tNItyUTidFTKriU6/pdy84UvGesGgwSJ2CQWp95k9CyQUW
wVUPXcYUIVtALSLSROj+Zb3veGSiHwXG7PEUCiVkc5mWy20TiinJCEFxinCzvQQT
lIwO7DCjGpzKUzROsf3VcQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
fxWioTLu4kWd//oWWdWaP55on1Ajysl+jaBlY73M5OlBEy1KderqaTEJeZnQe8qa
Vv6y4jkKW39yC17E2xTeXT41XYvk9DxbTdQL+ws4Bp5KucSzP1b6Z+YUhEdkgk94
I0UGiw3hc3AQdZI0HNSCuAEVL6UQhGFfE9nD2ViL4uiN9yZ/qPbNTUpySAbQmf7C
FPMqM2dAcKZPpvP/uRQc8NhzAj7g4bvqU/AlU9q5wn+aNCgXxb6DGAdrKqJUPjL9
N3dLUxNsiNDA6sragtnQChg4+Plzm4QydCqgqgBlmSTb2BZ+wFTKd7Wk04Ck504a
BBm/s2Y6Xhf+n1Svc96XPQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
xNlzpjJmJCs2FpfaU9JQzV0CQ+DqrF9gsTSMxOhWvczlvwqeX+zj1hTG6uc9p+fs
VIuR+szNXq5JJGNC3n96H9xoYZ+raC0EzP5V3tlsEyOvsKbgVp/jTwQlMcCRWxQD
qf+7p1/pRTxkdoEZHI6PN4lAcF/Lys+Tfs4Ph7li9j3TvZu8LLe6QmGacxi2onu6
VZQziWheLPmAJfiaYiZPQfQlnoicDhKXhyGIstZi5MQXqLKHHoR57LbFI3xC2d1j
AMa6Ekx2GoGDyWZIUSLLMyRwjiMUxFrjDr4tMf/xSMkNE40QDcLRWCi4RBkI/hhl
zhsWXV63JLJAMALnqg8d+8o2l2Yik+TN38yhAeBw1ZulEqC0rlPMOjRC/qbyXFII
s1WjxjXUk6Ri6bzgbJhuBXXLyHFb5l2mxStnKkcQPI/5/ve4x33uhqB2sPvEwyIR
Og0hJkbXMtk7fqDryEQYFZCelnrX4svLah8F+Bm9B+v2si40edfMeHS2naLUWbFm
Kzz/+NzcrIzyjLM97i/WxVNpTB2IApiPMmzcAwTO7JZMh1X9VXSOG8Ug6Toqr/Dz
11kJSoJL9fHnIvpuAeEnxiFQCzbHC9FSHAcI0gpuNyo4wedZqU0VknRTTJ2p2TCZ
cgsYsTpxzAGc9g76w3fdJ0sOhSaI99gNrTmED8YNY6R5R5Jijj1S4ozjUiutuJSF
hUHseYxakh2iV/QAN0z2kw1hir41d3DW4hWqvCmgmlgh/mruIJG/ONUJ1hnPDd3t
xxqYyYcvBCt/4MO5JfcT66toQCXc2dxG4OKtrYsKj1TDOUYVn+/wMV5fwrihJTYg
GM+fmBtqZ/CsOj9DJCQaYhviDX2L9jN/g6qqpIR43vdeWqafXwOzfc2RpInMohb6
CEU1ef9xwRrrr9OJM/yG/CDm9lF+oeUbcrAF475QO7dydRP2rDMVd7RmmJW3Rnds
/+yfbfACsHLaFQGPWK7qPA9WZqSRPwqbO2SrSaTxl6ygva/gEzGlMHW5QQUxjfvG
7JLlf+e0nAgVuql0s2RZjFr1yfUxYaXP2L84gW8bfFPlrdTH5IJUNlJLnmxg5cCd
FGhx/pFYFmA3+QTfjB1EiB897mwMqFiNrfFsQzdrLgbF0yQ/Mhozb9e1KZPQbmQR
KJZ1iNjptgYsCwE9WL3EZlajlkIsujRl4WEYIkuo1vC2ddOxU27pjccRBTCxjeNO
l5eVSTBywhJNewqs4sugNhE2rdu6PwzCLagSLiT4ceVSUv5KCvvlUpwZSe/FjgyV

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
a7dwOwov/HOmhGhxJX1j3aB9pzZCpwMLJxfsU4tn41wOu0itLM1YaRxwzFViDxvz
pz/de3euHbHimfj3pyVzx+udF6vqNg8RpWPk5OxRiL5qoWmkjAWLg2JWBB+m01rQ
IYtGIN5lw2moSyD+LoO7yxHR/EmadZBejBVd0HJl8Os=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=2464)
`pragma protect data_block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`pragma protect end_protected

endmodule
