//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module enum_int_top
    import enum_pkg::*;
#(
    parameter   AXI_DWIDTH = 64,
    localparam  AXI_KWIDTH = AXI_DWIDTH/8,
    parameter   ENUM_WIDTH = 288
)(
    input                   pclk,
    input                   rst,
    input                   start,
    input                   i_pps,
    input  [ENUM_WIDTH-1:0] i_enum_data,

    // Ethernet Address
    output [ 47:0]          o_host_mac_addr,
    output [ 31:0]          o_host_ip_addr,
    output [ 15:0]          o_host_udp_port,  
    output [ 15:0]          o_fpga_udp_port,  
    
    output [ 15:0]          o_pld_len,
    // AXIS Interface        
    output                  o_int_axis_tx_tvalid,                          
    output [AXI_DWIDTH-1:0] o_int_axis_tx_tdata,
    output                  o_int_axis_tx_tlast,                            
    output                  o_int_axis_tx_tuser,                            
    output [AXI_KWIDTH-1:0] o_int_axis_tx_tkeep,                            
    input                   i_int_axis_tx_tready      
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
YaPtFZA7SBl2Q+v1nhKmI8mGVHlHcj+Gj5mt22Lvujk7UvQootqF7OGqLY08pHZa
+nBwzr2EFquZ2LnfNC4Mm6Fw0Y4OA6DkW9DlI/xUvLPDsVvfiw+kiHlEZOZlT9am
QyQ8zsiY8Jkp8ROIa+dvB1Gg5Ehu5QVAbCdBrL8gTnLwcKFX0wqxgw/4dlS8H2i2
719Byy4kjU2IZx5u9ZvTVvFjC3j0tca9iRLJ2475T8VoOVC2EBQ4v9H4ZsQfS1+b
rKHS8EHJ9+7QbBXZxoC6Adwz8FlUcnbIO1rn7kijX3CsN0Ku/RIR1QZuRuo9oK9Z
peN4cUQaWs5f2xI27SUTqw==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
tbmspspCQsB+ZlKKUorIsgF+KDdD2ydjSJjnSsGsBR4ElAiWrmv7ZgCWdH/jNMi/
W3t/JimAL1/TsCuiCNsCB3wbOdunXzRGJ5lzTkRM6BWqr+cszJMssOywDgUEw2Nx
hPU7zrJK68UccSUbdGq/zfIJmg1W3FliohOkPKIO0qM=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
sVU9aDdsEEYtXR/yTv6VLA5kq4jV8VS9lhsljgzLB+h2PvP1BnFm8VnAt/6E3b/B
KF794WxApimEzIggM76louMW+Or92z9gVWNURqMYHD76HVE6wckdxF+4fSmNU2Hh
0IF/nlYQFZ5o+JwYAomTsG36QbwFapYtraW+iDopF1dtRu4UmhnUKtMhaSPXPQ9n
JP6pRchVC0WTnLqOHs6TlHr0Rat/lUJs4ph/U7W7tgNuTtScVirVX2XmC7ITN7VD
2IH51gVnBOCbfZvOpo7riNRTqzz+fxNirfia6MDxyjTFZGjqpG1p+rd+sUWNwIee
VeiwBpTcC935MrmHohLcfg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
T4Slxg07CwIURE5k72KUop0KNOeIHGdbv+mdN4EEC4Ig9ceCbPFGjmJEUshF9Eih
rSlKFna5GZTFj71gq2tpepWf3xtSvYYs3ab4giuAc8kRdCYbkl64h/IEGt4CY8Op
7zwQqYaU2G0iosq54SPG/qB81S0WhpJMO7GYQGTkuKA+jBaOuG5qzvFlQ8xWlJXf
ZeivtS3eSHLN1COGDAezCLKNEgka7VkCvhq0gAI1mCqf7pxbjob4T8UmgftuaV4U
ZocZ/neXIpCKnJdnbmxtqvkS7FLkA+/SCMRT/WhViZUbfgbtaqLptKDuP7gTz/3a
wGUhg2yBxa7zDZxMs2OtTA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
gG9J6kZg/IseJyLT5JCmU5DDHdwx4Jz2gPUK2G/JaeScQVCQcPNoZizUqNBAQvsx
PlO/OOt3G87rVFxDtVu8348k91w5umwGu8B9PeTrpwQLkMEUzKtl7/M9tAHIEQaw
KiDOMdnGbvord1wRM+dZT4vUI83wboSdDH1FdGp33BEkGg2O4FQ/GBHkdVFNoldo
nNsTX38xMRXtOUGz/78ZjHBvz07a7ogVlheMyFkot6RFBWQpro5TAWTj0bpyOztf
fZJuiUcAUMRadU1AC79RWGCtD2DI1raAf1OOqsD1Hq7WZ34AhvFbXp8gmnCjMGNQ
RyJYWX8OvNzXuxOpN7bZ8A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
fJR4yOh+DQgetxXgtPJrYJ9l2Zhan1zjN55DS+DMCFMLwh+2qwdfyiTPKFXGcu9R
yJ3orwYFWzB/j59IVXZG8qtuVIXqpw1uA3cmiThu5pya6uv7m2O2emnNs6AiSIvU
dPtKjb/IlkQQl9OKFKMPyZOmnThf9xiFk6W4ES+qgraBUU8+uqSd+oRqMGTUVV5l
xedUHmEmnMkofCGNHqecSo+1mAEhjyIdOCPlHbAM6hbMdUduKpRDuUbVlEeJ09ra
OxzY0Y87XiCC0jswy2L4yKvFlDbjUofwJnkF30AqOMyB3rjEd5gzRLBsGS2vYMCV
ZRgvGPAHxtR1qdqQ5nXcfQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
gzvsWtLg8FIFJhGXBwKQr864kOvDW5miqe4Tv5NKvW+HXqgsBWT9vWgqRG9kglNq
uV7AqmvFC/nE/mR1QIrWp6aoJooln/a6Jv4lIl1m2FclTGwglZaASod/BkWYtMXk
fDnjkbHi2poXRiW631wQTrz2eg1izuq88nNOrrnTeY1zYt+p4VcG2BH7DVJQ+Of3
fbMpigSKQJ5iSR8ZWtqNtWaS1wMhzftmY8uGX7xs+2SK6x6FFtiIt/jTzNOXzn75
AGZI77ZNC06L8cMUPNJh2JRjroaJxCGoq43UtrnTIsfiaOubQOcq6ND0RbOzboVk
W/8cVxgzMOl95TDqV70JZf3yTsx8zuyv1SHhw0LS4J4p/ZNQpH34lqzTkyriNOKY
OBW5a/n1lXREJeg7Ht2Nx4De3rhm3D3VEvGOkWvdguQ3UqiakMe7LHH/fDCbNQ1G
4dZxavKASH0haomfIOsWfCdfjbeAMwg1rffl6cnViP+KGRIgtft5ncsGUzz1IMxq
4ll4rhU1DhHc01rGOfkmvRoWCCONUgkmbVnKu9j87KHcOqOBSDsXvTL3VWqBIWHK
gE1Mls+U2uQTapHEEc5gZYbUOKXVWeGXID5vEuQaSgO3XRB7vIl7CdJx0J4s2CXE
D0Or7SUfY7PEt5gzWBZRg0Z+QBTjNdlaUivcGSqTZTDMh+BftJ2fO5ED+mMpeCm/
cerZf9wXh7bCjMzBOpPq2LV2wkebjzoRpPiTP0uSgRDR393Hj6dKh7Xq35PLv7bs
xjbWkHK4MGsykFyv0meN0/+ncEwziGatvbV7FmPnt0PkHPu+Vd52bqO3eB/JCpln
3Zo38QrU7kI9OoKs5479A4vGtDtALzO0wLq9xb9FjrFkxdOzX5L5juVcjEacebgT
cCfU+YtGZ7hfhvtMEBZ4tWhmBMNI6yXWxJV/6yBmDKRXYj4Fwi4VrCEaZsY2rP+s
o51dN8kQqrp6LDffXbg+gMmWKPrJUrzDeM/Mp2nsDrSidNsv9buKXrK4GuSj0gyj
A0i4VnJNy4dZnypNJ7ZPXN7tgruMZ3KeB+jKMe6AMrJo3gEFCaxVXbLF7/LRAWqj
ZwVXPmXCC4PHdR6iY4GBhCrl+tTM7a+HseRal/XkEylQxsloXY1WAOJ1lPEP1Qcv
hm5+eYwrYTZgatUux6NvDnWTGiOLGa2Zmn1JNfAf5UjUTFCqQNbXac0jeLKwhzXe
IBRnhry44/5D8KD5JvAevrcui8DHjw831vXNjpBW/uNR+XzCSALKZ2ogCCfifLeW

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
YZV5DH2aBpTx9clMnpgYIfVMp4/+O0V3fRgk8W7Iv+uQad49QAmBVmd0NCERJXh0
eiNSYJ28ykqIbFYug7Sc2TyQ88RYDH/iidk9/5t2+8BoWPE3Q4SCCJRKRbvY7bhE
8X57ea4MiZsi1a35axnrWoTaFqh/BAzWto1oMDSaiG8=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=1936)
`pragma protect data_block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`pragma protect end_protected

endmodule


