//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module dp_pkt_ts # (
    parameter N_INPT = 4,
    localparam W_INPT = $clog2(N_INPT)+1
) (
  input                    i_pclk,
  input                    i_prst,
  // Request
  input [N_INPT-1:0]       i_req,
  // PTP
  input  [79:0]            i_ptp,
  // Handshake
  input  [W_INPT-1:0]      i_ptp_sel,
  input                    i_ram_rd,
  // Output
  output [79:0]            o_ptp
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
opMu3h5BADKm1K89YDzwaC8W4cHv+DlhMhO37ulZm5LdSD+1/32rkAqfT2Qhel+z
LIhZjfoZW4mw7a8PpJyjv26/2BBrxKggJ4B0stgkV/QraBN6MVU8jwbWQi+gucKV
Cq3tvYPOrlxfa5gOn2bQ5zktDLLgRAtRTWqZF6ebbH8tgtqApYHGKi7GJ2cB/+tc
ZPQHDru/PFY9kTQ60mAK3M+8cH79D+695jUKwDj/qFHkrHjVLpwNvzJUjwK050vN
ozEmLWMscWKwX6nkTPAJU4Bsu5gtsqsOd5cVjb32Zx0Ck8UfpfcGkuxuP/ByRFed
MdLPTXtq/VwBXURDzME8LA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
o2LTXMjcpkxn67qRhRGNufWav2Jy1Vwp/hq/hVOBKVw7+M46VpZcL/LMhM4gmAAN
ZbXonwsbvU3Z/PC3Vayn/mrZg87Eoi9ISMeEdwxy2tv8Nw/qSNvG0OMMBjzTzW3e
VqSj8+5Cd2gVMy84kuwlBYwS4ljNvXOH5JAFzA+ilgQ=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
yU1BiIa1p/nfwDtFre2E+yRoU1ZHULWaBmPsyUGdDlP7uyCKInUx3MbPy0RaPgYf
FC/eicwUg3bTq2DCQMdTTDC36FG7evrkcEekw3R6B8Nhz32ikMRuWANy9U5lzobY
Ym4Y38WBsa7SXaNuLc2/QAMB7MMjRZE3HhzFjr31R8xzqBtk0fxEnTP08/dosG46
7fyN17W6VD+QzO2rRc+B726Qh8xEUHckjHcyOjTs5DvEqFb5Gmo+EGHhI+vGmMza
Z7QT60GXlWkOC61ZMWB3b90dihWHp/GwNnEJT1vUnxAPAOCG3OaUNDOZuR2lp24J
a/aVMrBMAu8VlXhlUbw5/g==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
fJobx+Ty3q2LmBHvShPtkjat7KjbrKEuvorTSO3JgbEJVHd88cjf27rpyxCJy1V8
9t++hA7j+aEONu6egAkRFB53q7tdEG6JzH1v2nRU/LMSitCCiBFykOu7JQmiwuA/
cvi/jcN0eImexJ3HUM5XyLb4HocqXt9fQNgH09JbkD+RKtLG5cTdpFhc+f0MCuSg
Ao/ezpYbgr1ngY6rsedeWq1ig3saA6wh039e/cGqzAVW9GGagmNO5se6Y3E9WZtz
cVtur/APE29CXpOWWtj+zytKNOm3P9DZq60ZSK/VuI+BmHAfbbiO6wEkAkgsfGae
6nMkKawkRx/2OsMsG9/bCQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
yyUaXiYYdRPv8gNvyfvGAMAEsfleVIF93MRMSmTdbmg+13hg8mt+WsVIeq6VXBJw
grXeF9Y0VGLAb9dkq7Odm27hZV+XaGr1BCY22pM/ISt8EbTBMIKuvCeZXuFCh2KZ
dg3qrG0vVrfzzOsZgHkl/gRUw+42R1zzwHuEKb7iqpNuXZf2fmIQ6FhR7GbNnlxU
6c8degXZqELBIiEQ1pSthGX/H4CBBSKJxfN1IZipH6gG6uuKBvWj36sUw3OuVqsF
V1MlNntlhEBBg4vqKCnYq6hX3BR/3tGmpBiTyz95T6cKc2Z6nhyYP6Skwt2demgT
P/6VkYlGP3ggL8YrnPixJA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
yQIMporLE6vXNERpIc6GWMMglrwDRkQQ/sVztdN4YuWAkxb/AoILdbVM9El/fCG3
FOdiB8NCAvVn+D1pKCgVkqtnJlEc4sEfL60gie+OS858UfSxBzzvETdkPD0oPoHg
7629V/2yzmxW9VoJKaZdpiKPycOGADrwCqk5xGKLpBaEleHA72s8cOjGdou3v3hB
4/xYFuXYGxiAdiSqG2k+BcV97SOjHmR36pffFpNBGTRtsnYkjcGxW9ci+aVlr5W5
xwuM6qOD0xapzoNSyT1lxogszYTkGQ0ox7cTE8jX6VdyJChBu4mG1jrC0Q3mmrm8
WrMTKeaqKaS323SsS4rLZg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
EBxNrWv6W7cIJRD+oX604YeQqp/XGXWDS9NAq7lp/5FopvmmugJ+URGdBrTygH2n
cTD72ZsaC7TCrSliy9X9FaTFLKvHK2sZWnh8ReiUgSh0YlRej8rqgA5aMEpx5ggX
hobsp21aeUCIpwYr9bo1ov2X6dBRatk1V6FTwdzz0Ne65pWf7RZuBRvD+hOVFlHV
lQPoN6UG5r2C+VAqo/qGDNJesuMRAv/XpFprFJIg1iMtp2d9M2O5c16gaTkmzoAf
r2it9ESdvs5vsfSLZ4K80CcFC9NTWZb3UuwzrBdo33pO2vWQT1YV0aPJXUcjAZWL
OVuwdmYpghrBttM4WN7Wzh1C5JNXIqd7huJs4pg+fkY7U6rCkj7d6bmlzivJKVS/
Cau4mhT3hxTzBXKokF0kz1AGFYEcgDmCe4b1FXcN/cRK9kSyaUWjVGg9D6rXOf3L
q8Llxi98V6ZTtqz3r6Lg3EOmgLuBycDNMkUAY2dDhyYhU/wKsZBA5tUfADOORovq
t10jgQzvSzSa5OQvoR/bV0A8DNJR8Wac0z31VXBnxVf0EByLK7J+mGa6M1YPV/eM
pZdRNOdoQqesh6E9OPuRIUTQ+6IjQMFNvH9gXTZF/2XZnWNYYVEwEzkWG3hEzrwi
YaBBEFtqRh81G5Uro3zDgiuG4xthQwvoijeeDVvQsYvgEUmIMu6S0CNKwOaBGhT7
Pdxe1IHPn/q7SYe/cX0io5QzI7w7WMiZyKKZg9WE37AzfoMqf/NVHpgfK9bX5hbz
a8hvlcl5LYS9HQFQqaSTFPH6DhMbzNrxahiItjF65ttSYVhQ0i6BP1zEojp2aPrs
XHXIyiS1lykxi7sFF/T3pfsoUKlMoNeWUucRV/fmLqwfuaxy6kNCnXaYyBWkkR89
kC42kkdqmhbtJ/ROxxryhIf/rtdEyf6fE+OBWbIGV1C4qeTya0BKeJ2ThEdvNZPr
DmCzCbIUS/8VtMfn0JALwKFm13d9Qd4XPImuTd1G4/rSGxUvXWDSe0sHvOV/ozWA
ynF+9/+njrZHxDxEQyC/fS2TtE8zApKbxNrhp6sl2HKgHHkh4IU09A6rLFHg+FkZ
h5ZrmlTM5dcCLwMmP7JGIevUdSIocenHkAlvAbVWUjxtteK+RtWjLk2CkM6g9o2N
prkNMQKndoxq0E8fmijLvIH9MDwiuBbg0ndC1+O5nkbraf7N9N4MiBdfZS+Zpgcj
ehRrOmmnYlrWgU7M+zD7D5kToX44qMgw9SnKi+fLOoDi+tJ5k6+Hct6J/zwjzxfB

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
MWxnoapjTaNbu8WKfOa36DN5MZF4z6HI6piLZttNbYrNdl8/DVf/KPW4sH2DLc+l
tMm/OB6XjAZbCuXqJn1ccyu20CGXp23Gp2zapZONcaSBlDyqYeOzXTgJxaOeIpk7
7wzfcG0ImU4g0niSBzi0lyqsa14xvBvjFXNBgKhbA1A=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4736)
`pragma protect data_block
3Vo23fbE81rb1+ft7okvpD1RI+ZFry7ke9qoexC+oyH27Ca3ZlARjVbHiUVLv448
69h2tsPYo2OcW38bL4NeNbMP3bM2xUy2WNpHlFGdaDjf4ztNnt8eNgA7UqYdqgm9
nu7WSEIMvZ4Qwqfkg6JajGO2br/MjG0V2unKnfQnWxV/jYR6sCN5g3QIt5Sq9rDE
diG8hd/1PGyB9yjofXOrTN6w0oEHVDJyqwYxLwqMfUGa+zP9bioHwoguY2a+0eWt
Fwxn/lWKSFj0tK7ltxZCnjlCjPuQLiLBu53SpjsuveLiMWKrIDLLi41fDG2SJKTU
WLyLMQeQ7In5a2DEIoo2nXdTRkw+8dwauZA3kIZtDZqtUe0Uiut25PVSgRqV48d0
/Hts3LfKiwHlBHyQyz+ZlD0Gzbqdq1Ttaha4VDlEfJyJyMQHQP/mA61VQlF7WGMO
1EJb7O77zoLGyhldEPFIzHumwXf1eaeZa7RcCDKwMBaQ/fB7BspvkmA/2Ot2VnCO
D8YrhwEjlCjOSm0VGwwAHdbypr0stYZKAW73Ime2ArhfUFnShYqYjJYthHjZv7kZ
fwbJ/SGoOAyzeTOAcjqfoLAciUjXc6ZemldT2eYSmOc6rCcfdBajnF5lL0Xo0O45
4HAZyPvbmCvWo7aNEyv8ygDARDDTUE9a8SymT99jZKYnq6KPtWjzSJ4x4qW7EsSh
WdWJHB6Uk3VjfGi2YhO0c1TS6zqOfLqEHJjH4UxBlrtcofU11xI3aUZa5nzcVyDc
Byd5eXWGLYbiui7T82AGZL2QzgK4BrysdsDbAPaiepwQC9enxSbsoLvT8FTEEhuS
tBz/M0cJGf0a/s2fkGCM1XkzXLHQvANJQFXFuNqYdkRnbaIA0qtCvGpQ/wVvh8tG
V9AiaUgIqpzUrDN/I1/wmtIvXkvpMX5xoVT3GMtqUjyggWiX8DIioOqNxcL+x7Lg
DGgdE/IiN8l/jY9dtoqvSpALX/1NSBoE7r7bpKx4qXlgQDvTMA5DXt+zF8AVrGta
LPlIhIpxD36wO7r39cMRMZ/v9sWYC8W5ElWs/wumqOZlTkG6aRjXoZxpjzs/JBPI
kiFNNH50plA9n9uGg94/kFSlURwO9bji8UvIT6fzWUrt7K4VGpeT6kpqjzDQIZgP
aTIGXr1GVCgv7Dfsg+ZiAn2AauahAGGK39cBGYKrDnyWNQjAXdiVF4MGSpGuMJps
/MJl69QDfnuzBNsQ+axAPf209BaGab6y/s/qPm2xcZHFCfdttw4YkFmYq4Vo5Lgo
njQO0vs6PV0Eti6wIAQ+ifkiPcQuGw61xOBDpkMkG7Wsar50Ro5KxWg+0AjuECX/
gK/jYhIzZ64jDkRuQOhX7eeeoOTH3ato5IBre8HH4c18CelrGW+Bx8S8IVWEC5g8
FR7ddhGpikdQbF6WoqP6qgC41w3eF7MbV389u2WDo2XCBJuYqvnwoie+xhhsRGr/
dlEp58eiz9YX7AXe6ZfiIeQwO0nMWSNGzFcijjQh4K2s8fba4xSXgeSaivu+2uqR
sgNnAiy1/iYKyiFJe6r+vHksV9oy7IO8ycLoHAQF+WmPP0ABcVd4V78ydEQKe9Em
/65R3NFSuwcjvDjCgWUVezXM3JncxNIlVHxA7xrGt/K1/nSTHBUTosZw8DHBgU9x
Jm0WEhc/HCjcCLKZyIXELoYcilEtsOYle9zn+v507jffl+kVVLVf3Njj8dxcS/QV
rpNw2nHE71C5YZJ7Wv4+s6xpJXTp70Ky4DSdwCQxunKceaPIxmMk28z9zLJElajW
9VJ55F6cbOhF79hN+r9Ok+5DmjUkXUXuov+oz2VYVmtKajUvtkFpzbcy9SmzdN5U
DYn/8IPRQSEUB3hDBFBP4l+qClf6kD484lyZeK6KXOpWhxZLttmFCH/kKLS55CIR
SRHs2fEsYQwqtMNI841eU6vtWMhJt+Y2TYWQNQlH/EGcadveD3mAn0nW4yzxLYFu
eYnmqfnLD7g3xPi7YVgwQiLI7FEKRGwXG07cxIwslefCXWUKplmEf3rHlNT5ZftF
aPjMp+qD9TCJn+qnfTAUpJM+0t23FA/Cfi56ULlVPUCzLnZgNdgbk4wYXbtZAsU4
Ky5v+dG29C/hqs4Xur5i4TAj6rt0na+FNcxNmDObPoySLBBrqCD/XdIB6uQyQ8ib
Bvlcgn8IqaIHColHotBSEBQ7jDZiHMrTD0nrclnI2IwPkXWCw444a/1dcWTEYucv
ncmIg+HmspZdbPXj9H8joG5uWMQY2lNjAcbzyDXmFO5EUgEDoG1wG1le83zHlzXD
90E9eyjpqdKlhIRBdjX78o0k1EZAKiJufOuV5N9zXoYzKp4tWptmga2HTbbHMANM
tB7moRnDjsrsp6ycl5z6WMs5wfBBIHr03R9gSfzMHBPtAuyQhnB4FtU+iIgYaRGr
VHrcxMjdyjGD5sQOE/CBSQamcrFwCx0TBESsGaFAm4btI5IlFSEVf5IcT+I/6Gwe
djzWDhPd2fWFMerQyqHRY7kn2hfbBfgsRBq7/VdAni3X1rYM3EGU6PjvCS/NwvAr
meKPo4Mxg4hZjScQx9WkcDkLeGAsZfP1+RocvS7szVSnbpLkKekqBdkriuHykb7Q
22dW8wsEzMS+sdEbvDrJNsdcBBRvD7GwidkZo9cgFrnY0PKABfuf15c7iDofrMYW
Df71t6Et39g83pvx3/RuGYwFNscbLMujPDMhfHwswisb1kQu7IJd8PsxofKA/cpl
ByqlzXnYRWcS/lniordijFVpcyzFdFWpl5sUJmqVr0WVx1vZ7AEbgynJQEMOxhhK
DYd4kq2Q3OqY76auwngI8lM9IXsLs0uimMBTEeHNopUCQz/Bst4BAKmVoVqR6ePP
Ap8zubghBcBvMZO1mn0YEfmx+w3UCvjboUF97WoSqxyRKccylN3kD38MfjneD7h3
aMNvpyyTPJj41uDF/ejUANshbYkb6sUFZKQTTiZYjVRfZ/0HeX51qN74yqDOKZTc
Fn3c2fiVJsxKX0VGjiSD6YZOUiOlSKm1pt3HSZC+ltFm8N5FLVFV/zz4yWryToYI
k0XzHMsIaWv3cqthhrqPFwTHsTZWViuT6FNX+4oKxT0fgHgsGO8+DudK4quaguqN
B7r2KxnN60RhBwA0jeH6Y8gaNeNPuU7IOvkUTvmH8lIO3Cq0h3HhKRESK6qovhn/
2oVrUQgflZliZI7/pYG52lE+9lJils7w3E/oXZOugla3/RDiSkmWGT2LNmfwTOO2
VQCf45fsc2GUqpUpRJmADSQaxFsfBFnnfbS8aL3NrYk1fntBN0KNZHxsCY0GR18o
LNNbHSniGezeQ7exNkwufLJ6dFJvZLE8cKz4uVeB+REdnvaC37pqIv0nix+QgZak
V6aedTcQCKnBDnWs6BixSOLXRzOxux5D70FiJGtVbKU/d70DH7eNCtjRrksiRjF9
DnB5GuMXhBSP6c3N1mRG2z7Q1R8SqGAOJgyVYEhWUShmrHvc794m4tsuu9BE78rn
mte9ej/cJM1ukeuN2bJphVNjB+oqboSf6cSJTe6rMP4A0Ipnd3k0CGw1aILUFCf7
WOVEHoviK4qO8mCibtEcpEHJYtezTDwPY8JqTt8ho7njwTm3ewGhG+2yJfsKV193
jJyf97XaxoVYWhOT01pDSxIRtE1Ye1cZCkwUioGbGmrZUgyhZ2QTSZtovl4uuCUS
PJ0luWApIxwkrVeVgoy74IhpKGFqiu++zHAILVeWfydgH5s5n6pA5T9N4mg/LBXJ
yg1d1ISq4be4hQ1Em8YeXk2p3VvM5v/vv2yPAbpEK/7klVfzFcPW0pi/LizGP4kj
RiGvvrvZiVtXkdbmdA8zIE8EaqerHYbEnvwL/Sn4P/dv3oj6eQE/5iiI9P5bP0Pk
qU6nL2071QzRoju5ppku2ITLx9ey/FUxQlyFhxFW8fKmMYU3JM26OGzfRnn6Oe6/
fJ9tXGU0UkzmfvT0iAlKvVKu8TrXpvLW1ApEfsytz+qYm1O6A2dYmUuQNVCuAfyZ
ljlV9WQML9q//XmB5LAJiCi8i1C7/uFLxdgL9/6j3Iq65/CyikxXTQiKR+R3B2Ws
IczKeqi7Pg4oNqAfyDaabCe2aqmoLCN305bX0FMUM7KTZminsuA7tL4RvHYm+3b1
Snvmgc2TDcnm22yZswL01lukyroJtp/opKL0YUmTdcFsaPewj2jwW8CTdo6ZKBcH
6//wZQy0bB0a0LC9e5HDk0rwnbnMg0hNZogyTzD2xLBPtkQqsIVZT65BRl5/CyHD
+2G9ntA+oeoBx5VZKFIlUNizaHecyVM6EasLyVLVkDkpRnHmjp1KXI+7w/AFZkTJ
zyxD64dikp3u8AHmdGHjlxQaL6HMA4txw2h1gfmLACi9y8BQBnIKZWI56kWbRfiq
Sdv/z0QrewcgU1unLpDW6Rs8CsH2XHTFagB8ejC54gKn7MxAOPiocI4aME+Uq/Mn
ruilMqyiCmbPSisqfEFhVAX0dUg+2QsaX7usgU4d/U8BaTCxI3LeQCv//VkAdtU4
7KNdHcMwkGGYPpUgvoZxY1rfmO0l70FyYjEnoMvWY5yUTu9+RxV1saeQ+3YNxms8
l0KXKpVAdHZp99mrMWQsjVqGBewa91jC/Jy4wyCzetNE2RmXi+w55kDNcS4mBv5W
wOlFccuIWw+6oRNpY8EkazjsNTGMmYVra9PksDxbPTnDWBO30jwqwg39oR3FQ248
m0cbJn7VNddib3qESbMxzn6XeWNKGi/zsKVyo0mX9Wp5yry3XPG3eDbSzrhDm3hL
Qa6cnKjEfgU6Q7LPdKoa8C9b9/E/x5TVOtMSd9g6mxy7Ib9y7sWksAY5yNIdpOtN
Ik875jDQ+uv5aH+3PzfLyDKvV5Q4ByzPbfsR5033i3Hzj1UtR38DKhPDGBuNZDWy
LofdNIHlKQgu5luVt1sHptDJCEsfCwZwTZXQE5uRwtb+FdCQf99jfe+PmzrDBlHl
un6NzJkyYPXpmJGZSxSOcyGZcC38JpQSWxVgiE+7oLQqgoDr75RBtJOOFkokol/d
79MB/y8pcPrurmIMfE+tG+KpB54B70cXRyXkvYwyE8/Mr9huydM6cwaEiM7zCGPh
Ypodtttmzhd7Zl539AaGoWeHQfTFw/RnZku6RwJpDXXZDmFLOTfj55ptasnpz+TP
qKmlHk9l0QTxTEYqKCKJ+3zqhAQMzNUzZ/oZ0yF/J+GzH9jjJbr81kFg5gZa9GpM
omlERLNqLfED0wICA1FUW/AQIWE5usWq0wstY7ASpI0MLbmxUonuydBHoisZIHBO
UNbAmQeEqWLJmUA13b0JKVNf7xas7MiVmevGF7sRls8f+sN+qB0blA8Shmsv5Nv6
khD7IIY1aWBSHEbkk3QVFrX6IxAD3oGH8HOk8zhvva6AE2LsQwdN9Ah79Ej1NPZG
tiuT014nMJBmQv0hHlwzVqCHDfFetPMyG2Kfwl0fsrkNa17yS3zHLsGSujNWSgiN
bXspnUQIt50uMUqU7Iu/T1EZ8pcwhh76fX/p604QtSTdEBqkdI+/Jon0Feyl5U5I
JQWpQ2hIerIwIqRdswbu2ADJwfLWrrpqowgmctyS8bSOQxm7iEN0XYXJhwTESAee
R90hi2bHHl+h+wFoUKeDIEZehVIjXyEhaGHfvI/vQV8afuVfLlOtNipdM1Ok7t2H
YO7qdMCk0eD28MHfIKyfjm6IILk7sSJfeurqoMeqNhC3lm7+Efx1G/6EfxHbtn0v
+jTCsYifSvx0hIQz5fKDJ4WWacOzkFb7nS0sGtA7QUnDbilCb8VEal2EUTefXxE2
wQY3rOEW3uxWbfRS1BhVSWWskbpj19YEk6FTfhIJZGRG2U+IjZ+qzhfQCPeqhy98
elHXTXbS9uYbZ4UaZXqnPVmN4JFn8z559wLMErtruBrYfA87kpLgcp5juiW4CNeb
pgWoZugu6xobhtFxYJ0x23e2/9lrzp2e7XO8uFXCgajryE3lOlVMhlNpY1dovTLF
gTh+H+fZL7CY01HBl7UwAKNZl8d3T85BzfqdB090rcegqXiHCWSTWEAsEN1QGxy4
doN2NR4SsZAey1lNZ7qkOB12b8Uy7H2BcK/Y4lExv2RekKSwX542QEEjVF2/c3yU
4y9upiUxMByLgfRvsTz7YGGgtOZV9JC8AWktmUA4FuwiNJLS0XWPRit/i3DYATLP
39ba4GONzWWSUI0t/Q1r/bIZVeoCV5MpXbZSmHeylTmuFPpsTBO5zGJMpTgA03VW
sN7ezJFrkETwU45roJQGgB0miyoORRLQFYiUt3gcBR4=

`pragma protect end_protected

endmodule