//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module dp_pkt_hdr #(
    parameter W_DATA = 64,
    parameter W_KEEP = W_DATA/8,
    parameter ROCE_HDR_WIDTH = 128,
    parameter COE_HDR_WIDTH = 128,
    parameter WR_IMM_SIZE = 128,
    parameter METADATA_SIZE = 128,
    parameter PADDING_SIZE = 128
)(
  input                           i_clk,
  input                           i_rst,
  
  // Header inputs (vectors)
  input  [ROCE_HDR_WIDTH-1:0]     i_roce_header,
  input  [COE_HDR_WIDTH-1:0]      i_coe_header,
  input  [WR_IMM_SIZE-1:0]        i_wr_imm,
  input  [METADATA_SIZE-1:0]      i_metadata,
  
  // Control
  input  [1:0]                    i_header_type,  
  input                           i_trigger,
  output                          o_busy,
  
  // AXIS output
  output                          o_axis_tvalid,
  output                          o_axis_tlast,
  output [W_DATA-1:0]             o_axis_tdata,
  output [W_KEEP-1:0]             o_axis_tkeep,
  output                          o_axis_tuser,
  input                           i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
CsNC88CWPtUDbtngOoJz3hBgvCxOtB0O7SHoR+5Z9V2nq/7uGTwmpwgQMfv3OfKr
w6majF1KJMSy3CaHekHTIPG6xu/GnkhvalFhlR1fP0PEeQXl8ZuNFBbSgXS+Fccb
bnRSnlNBkypllhlLBC0zAeXKOFFFhZbPUcF0BANA1AinuUbMvt4E7f8qxUNriS1D
UFfXg0GMonhhbGCGn9HNKgPimfB+k/F437uQRIGB8QO0zkBIvPC+J9jlEEtTDgTB
Oznw8QdKHZ7hXiRbdubN+oOMlU6WuozEe2VCSXIeGLjt7ph8L+ISn8n8l3Jjyw6s
xrktkDPvxQUSqzDrudxL9A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
SK50nmZrB4a7RpOiF6c6bMHW/cm8WxEN3UuldC7tuuwRhz7wtQoGckwNPZ3zfuoU
kVW5f1uBZE+UUZxRzjdkWCcQ8aCSYYNyLvxHsjW+QuC/P3IUWo47m7U6rA4fDkXf
wtYVH5BqawzalusLiPik81g0ir8Gl3HaciMbucsuVQ4=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
wTNzOrXjClGTZ6FvSbti+Hee6x9xjzb3U9Fxhkc/IFanqwAP+woKfdkcDmjig5Nm
AXa0/CJh9fj7qWJUBejIKdO55pWLKZ4N0Ki22W5grR5TZkpqv4iPHoqUg8LLnqPa
xzjl0NfwQrWilxJoLx1pvnLyHAUg9Jeha1p+i2pWje82EVV+AG/MTo0W6fxjHKpx
eSptpyS6yw979FBmRezJ+K0D8uxIIhNaTHNCllDNakqHC615DwQbnLwOi/DebBHV
2joxFax2Bvi8PfT2RUtix4UAsJcEQcN5MtatSoLFO8MoGGMXGFZ6wjo8arNAf6fz
l9n+hlX8yBd57iYw6nqA4A==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
U6MX836uxoTPNV/hsSvJwu3BAZHbgi9xMLKXNWbXjNuCgz4kDC6uEfR13wl/XQmo
vx5JSOSp/OExFipH/7SQn56jvP1ULUyMkCP4hTbc7asItFOMJ4C4QeJHcvakyVoa
blXov4g5bZYCtdX+TZ72oy2elvJBHWeJKRqet10GDnkvL9Xy2Duin32raE/5DasH
ifXAbOrzBXiIE8vH5PWXGu34885kKPR4G4UAJK7hFy1cuxF6jgCdE5aaiOnfjTJZ
yvJ6zjE2zJeqBr5Nc+sm0O/ChinI//lLmQbeVmqgoQvfismpn2I2ii/UvAn9NbvT
4Uq560479xWjFigROyE5bQ==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
i0i8B+JoEDVc7hY1XWmeUFjxuRT6C3LLT0AgpXzNRsRGEAzf3nveKBgy2OjB2sTM
EBBIO+iXr3UM5irsYLpeYy/L8/XlpzO+06dXLFNl9VLr7VuoaApLNRh6UfLwJOR3
VdVouWF1cHGPEZS9oKbVmUFu4w11NEDJcyLmobB/zGpFAbfb2hkn6lyvWc+LkNqR
+6zLNWpcXdA2DDt7+htaX7EMBiAZ2befQWnjE+GFivg0fgLGyDTBQvXZ1NOVrip/
kl/2DS2aKWL215Ty52dUoFfdEuQ/rG3WiLMPwghRQrs4ZSc/XkkUKnvBtamNHD9R
4gOB6iYTxbKcByQ/nxZ2pg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
Ra5+lt9TxdyRoeaTyRXykOitkBuZoae9R8ASdH4HVlbuARe7ZG93gXsiw0AQU0gS
4yWpF/HuYjYjewkZJJ63ZvfZvLeOKtUVfG0f6x9Qifqm+pPfRBM4bzYnw7pZ5wPH
Ogh1Wl/znx7Uj8x6HlfXaJnMadqnZOre91BtqlYPkZ2iGqSRUnh0itMri6mZdmCK
VUpMULtjjqbFYEOq5t4E3LDR61tRqtla+1zgpUcKmTPJxWky1CNJQ8h6lXCyD2zu
plMHeRoWM7qB7q8C0ld49el44x7l952Rceqi4FP7jkTDeIRTMvgbe7RezXJVc4ks
Pi8khTNdU80OhRD4Zxu5VA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
Z8N+a8wR12PqtSerXi5H771wqLowseshXRZLMgEoXqqSHZFLXWZg+ZgMF6LHvveh
NH4SqwTrkPVYb2Qo50dprRvWI013HrPE4ybBEbCyYKklyqJ4YIrt98TTIRcoTud7
v55Ntk9bguH9X1Drh5++GC0WB2AAf8+AghTFK4KRPS/dKZ5k4dIfTuTPuCYmM6QH
LWPaQYLVOSSCQDMQ1aJn8GdjnCT2b4L2Rc1071yXmAK+nhYpWDCodyK39gz0ZjXI
w0DP+Q0M8HXPNa8fhn7PG7bsrXO7X6Y81CSuqB8DMuWoJv5Yd8NQLc7ilXZ68EPC
U0qzLUDDp+e14rQzl+g8wiRABwq5QUbgcBSETkmk9l4ieFFsMoP1RCnehUAbyl81
nNkZQGd2OeL/wabGWrEHfU7jMTZwqPircQpORQiQTM4SWfT9DEZ16uvNuLS1OkkR
41r7cibWJMCcrDkY29IT3Nq2JrapSguN3MqjZ94l3wYZfTLJNy8Nkn6eDKUV1+c5
wXRcbmesubG1Vj1VGTbj11PFjlnAuv7kF4hbiA6lv+R4GqCqeuTIkmPDvRyPGxxx
zyoAlryk5s3n4xGgHVu9zpY0DbhPvnvKDHABNRp6XbDoyP0Y2kcarObVC480iBCk
+zKVtj8gKfU7zRKIJHS/kliGy+p4zEHY7+6dNF2+ZcxBQv3Id3wXwV3FUkS9oWI4
mzDT3cXXLzTV0jusx/R2zUEh3PPRwzWfb1LBKsk81NW6EVPDQvL/CtenZjN8fm2z
PZuTZRrEvA2pEJtFvCLC8oqCYE1e7HfiE7IxZA3FfiH4NjLCI/GXdvN+EuqHcugm
cIuYk3bFafj5/y+BXE4L4jt8XGx3pjYUXGWd+6kb0SKxROAmM55GPsKjFSDmFTuI
jUVPUh1GXWqH3ble0lUJH+GJKAhWvNW1pxR55lL2wIzOrNVXgnN4CrAVRFu49tO9
v2gAKNfWUp0D+tWTVu8cbf7m9M/+Lwb36CGtpNyzlrpygRAIZW/ASPhgK/FIVUgU
SPZzUYFxqvcUNzk0ANLbmEe5exn7MmpbRf7nTXFQNZe9NBVJoyn+LeAaf/CUJxvo
8IOIaTce4Q5wrRTkJ5I9BPuPG29fqY8XzDDxZ3XhIorvcE0QA4NbdIG/rkaqBjXd
LAo2holPZee2zsLwlds+BVARvlbxDGOW2GloLnweY4U9V0BARDM8BsD/50rDARpT
CqKbwBSBOGLBNq9rz0l0jf8EsrkvGIu57aNkAGNjz9ojVOGGS1HJQitaNC2YjGda

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
X59RsWQc570dPYRImIxuqs5c4JVAOJNrKRemSEXImYK//S2v9NVOx4ZwsFxZKThn
NToQyefSn/5D6OtsDmSMkNpOGL01VCd96VYkoxa2uaRp0VJj70ziJlHEor4x2y9I
DxuGuvZBb1dSPaXrJYysbJTNXo2Jl5lkoHwY5vXowGk=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=6992)
`pragma protect data_block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`pragma protect end_protected

endmodule