//////////////////////////////////////////////////////////////////////////////////////////////////////////
//// SPDX-FileCopyrightText: Copyright (c) 2022-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
//////////////////////////////////////////////////////////////////////////////////////////////////////////


module dp_pkt
  import apb_pkg::*;
  import regmap_pkg::*;
#(
  parameter  W_DATA     = 64,
  parameter  W_KEEP     = 8,
  parameter  N_INPT     = 4,
  parameter  W_INPT     = $clog2(N_INPT) + 1,
  parameter  MTU        = 1500,
  parameter  W_CNT      = $clog2(MTU)+1
)(
  // clock and reset
  input                             i_pclk,
  input                             i_prst,
  // Control
  input     [W_CNT-1:0]             i_pkt_len,
  input                             i_pkt_len_en,
  input     [W_INPT-1:0]            i_gnt_idx,
  output    [N_INPT-1:0]            o_tlast,
  input                             i_tlast_done,
  output                            o_unsync,
  output    [W_CNT-1:0]             o_unsync_cnt,  
  // CRC Handshake
  input     [31:0]                  i_crc,
  output    [31:0]                  o_crc,
  output    [$clog2(N_INPT):0]      o_crc_idx,
  // Input Data
  input     [N_INPT-1:0]            i_axis_tvalid,
  input     [N_INPT-1:0]            i_axis_tlast,
  input     [W_DATA-1:0]            i_axis_tdata [N_INPT-1:0],
  input     [W_KEEP-1:0]            i_axis_tkeep [N_INPT-1:0],
  input     [N_INPT-1:0]            i_axis_tuser,
  output    [N_INPT-1:0]            o_axis_tready,
  //DP Packet AXIS
  output                            o_axis_tvalid,
  output                            o_axis_tlast,
  output     [W_DATA-1:0]           o_axis_tdata,
  output     [W_KEEP-1:0]           o_axis_tkeep,
  output                            o_axis_tuser,
  input                             i_axis_tready
);





//put a blank line above


`pragma protect begin_protected
`pragma protect version=1
`pragma protect author="NVIDIA"
`pragma protect author_info="HOLOLINK"
`pragma protect encrypt_agent="Radiant encrypt_hdl"
`pragma protect encrypt_agent_info="Radiant encrypt_hdl Version 1.0"

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Lattice Semiconductor"
`pragma protect key_keyname="LSCC_RADIANT_2"
`pragma protect key_method="rsa"
`pragma protect key_block
kQRZgj4Bo66M/rJWvrqQiox4+jMyCRwvJf1EvBJeyS6adJB3ttjI0LQ07FG0RpmB
cdzaLF9vXjrPlwaKblka01Ci8h9QdL8NUXCppBxx2bNQAipkYjBNSgu7woazrsLN
ulVUUEfwfVPZ3eL1HnXSEKv6QpjnfwlgyQmfSzhtDiL6lTZNpdJteMgH0DYlvph/
adpnGHI5E+/ImCw7Gjh6lHHYheifJKfrVamQqXMynPjr8dcNyVC4N3I+F3EVnku9
HNedLNZz3VWX3uJTXI1DdifwA83+pn+bDader4od+n0S5VhmNQGoAf0smAIhvzs5
9CbaHGC4kSfvcF5gV2q0Gg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Synopsys"
`pragma protect key_keyname="SNPS-VCS-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
q/69XaYXMxefdCKjnW0CPvCby5E2fVuMQH+jNSjL3cG/bF3TxWYeU1FPiizZFuD2
4W8K9Punki0o6Oc+D8b9Dfp2WlNiBOhe/fuL3FDxCsjtb7OwgnPgSDPk9VELwYC3
uDjX2iIh0pmSx3dRGVJ2vvodC2d8H7aE4k3Lg5N0Wi0=

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Intel Corporation"
`pragma protect key_keyname="Intel-FPGA-Quartus-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
GSzUPKW3Uvfm61uCrS6Ap9OhgQF66p9aJAzKbe39c6X05cvTcE/2D5s7llzsIi1f
gil0PtFJMOfa5KCKUcGdPkHIZlXGgTOYfBafk65Qt+ba8nk1SpWnvdSI3gpRqMoL
1YDxdruiQiTMz3q8HxMF1CaWh5pHoSJgxmoB2vPkqm+4ae5JEVsMhpkShYVCJLrS
EdWsGI4PTwWtgxQR1DxcgUUTMTeB88AeUE/doXGaTQ2XdtOFC16I5wFvuRPTiXfj
BrNDcXI4dIyYYO9L8c40ZeWyH2KpuPc3zZMeUd/bwgX9GVmCrqzwW0TLWQvK0D6l
vdVh/+4itsHBJKUItNLC9Q==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Xilinx"
`pragma protect key_keyname="xilinxt_2019_02"
`pragma protect key_method="rsa"
`pragma protect key_block
U/7IUIqhVmnEuljVbV6mYyrl/th6unVVN5/OQVGWWezhwfOMX/0RTMJ6KyzlihTF
GKgEoXzo65y9YjGNGLAzlatAyarecC/V1xopf4apLylZqxTqc+8qwBS5VaZK9xPN
u0HLmMQI0ovNcReJ4dZmWn98zGQZ2Xoo7APzGFe7ZCR4Vo/xS/ENXoSJL5t0iKH4
1zQktwHruyNyEoq1KVK4lryMR8QSZaUVLB11E3zuc+LvDJNmYqXsYhxNzj2Z2+P1
QaqFb1wMJ9DBhiedeEbBpqH1+5oU9n8eCeg/PZM/+qFt9lwAWafU6NDXoEAqLTWL
X5xq1D20J9Bw6h5GFT+QtA==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP15_1"
`pragma protect key_method="rsa"
`pragma protect key_block
2+0SG3KWAwx+GGXtSJKJCOZdP3J7MRPc4zqj/h+Cp/qkyUZKRA/CI0vaR395fwa3
dbxTzSig4TOQIJBeiZO+5Qrp9xfl0h9Ybyu2/TIo+GI3PFEb7V8hT6tFl0TynIJj
bHck4uZnao+0iD9axgiVXFH3s+l3+WtjZvLsNaBiv0BxXZ/tz/1qVg5TzqQchyE+
WBlEoLmYkZiIXgRu4DN/a6ywb5+Y6h6mZOFaQaNifSSQeDAvRt0t658SM14QJOWD
FI296J5QySUynMp5zJPqWLehPMJC5DkLCg0WL3fSVRVOx5YQr6iUJ2GyzIvLwgCH
T57Bk1bKN9jMesomRJs9eg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=256)
`pragma protect key_keyowner="Synplicity"
`pragma protect key_keyname="SYNP05_001"
`pragma protect key_method="rsa"
`pragma protect key_block
aaY2nmFIbt/wwp3q1NLU7TYeISduwOTrq87zyR1ObnWZ+7QMvI9loKIA4QklHLj4
lNHpH2KUkwnYb1ZuD10n95Yw8eH82IjnKKeRdsUf+MRh8pjRUq8HkRvPszT7J47K
fWr529MWAINY27m9u7TI4acaQIGVK6HYy2QPb53L8S4QJmxdjWKSpgkDJIgIXZ6S
1mt3/+cZSB4z0oD7oYdnzKzOB+9CPuB9Ev0tzan5vkxvXbrzlsTt65Vzwit2H6gw
ox3uSxCr/8dwPsfaFnPBbR62EktZl23KliUcc2pYYUQQLcfXSLqJRcQyPJwRmrSU
I55fWUCgoDiZgcH9EFaWpg==

`pragma protect encoding=(enctype="base64", line_length=64, bytes=960)
`pragma protect key_keyowner="Microsemi Corporation"
`pragma protect key_keyname="MSC-IP-KEY-RSA"
`pragma protect key_method="rsa"
`pragma protect key_block
GEQV/EEntGNBlgYIFcS4d619lXAR1M4ftjhRn+VVO7UWPxDxERG0sNyx5ArHahN+
Dqw5zy3VBTNen07330A4uYKRTkft9NFDYiXpQeNqmNwzhu3BlLLGIEtbE5a5bJ4c
m03VnpjeIOiLAu+EZW0u4qFhlqu3AN2k4q0CfEce+S1lK4rThsv4SF1r0qrPBV7U
YWwdXXuJTRXovl48vqS/KAfH5CMGukgX2KaY0UyOMOmr0ZI8cJlv5cJ6l97PSiH1
95d8SAjQJkpMmqndPXJDmZ1JiwiZLcd1ECQxbDmgnWCz5Lj3oE2ONjIopD4cBuQk
s/svCJUVN5HiifCesHN5KjYhXlA0bapNGTJDE6LrdR+9jwzWe6mT5wlMP12RiL2z
t6nJQbpjRHRFeuovgDuhpIwcw5T/TtBKwL3nRvpFvGnYIF81EL5rUmgQLuEwxC51
eOtv6QiUMOOxjfP1mCEm6mfJ+XzfAr/ODHpBZue4dihwLGWOoNh9CMNmLt5uiqq9
EjlgMZqjOPTUCPysNZFekdf5OQMJ1k/WGR9pPME7QAI8uVr8NyR9kkJZXVIndRyh
n39IPeQXEFjGO0Dk6f2oFZDFbl1GAGndiAuMQMXDbzPYeMML4mRM9WrRwiwTaIH+
dXjhh2ZZYzf/tMRy4AlYDfr04lVN4QWRtTOcLxdpddQ2Bk/fMO4ihctDv+gC4C/1
7ynBh40Z8SOEFY6ZDQbZfOv3BMt2orNaWpvD0m2oFdZmn0JElOT6t7s2andCf15e
LKheeoXT0e9ikJbQPoy74Z1DjZ4mYwJjmvsr1joUC0rjR/K6GMsIvjIdPU/b8dfp
arJwhBshqIjsacIo9UZdEmrZpm5i0VvzCIRbeuBKBHByZV8qlbt9SvXK1nG0FYwp
6dtekrYDT0clNIGXN2x8MHyFzJ2jnJGKJtG+4NEqrFu5sadfbBD7Zirx2R5T41rf
AIRDXI3MMzPQdLj1ATPbHX2DGzFqSERDs7RlWjnpZk9xDRevJhEZgnw24OlLc4Mi
42JvsqxTfI2wWDHrdKbB5RvBOPSpkbvtwaWmS8kH14PIkiyAnY4EyQWUyauptlFP
MdmkTirNazB4m5+O6CWWPpYA0G/jhcdL2iUF7bgQaSuoJxpYpGHfr83Msvan81xY
LUTJOGmHOX+GaSkH0gVk+f3GGVpcsbJxo8MpBGVBmngQtSCYdKiwhhRq0aRrMgkH
vaZaigIKdYHdfi/Xm0MCmGJTSW4acAaRYxtE6TbYFiwXQXHMbkv9sOOtAid4n42t

`pragma protect encoding=(enctype="base64", line_length=64, bytes=128)
`pragma protect key_keyowner="Mentor Graphics Corporation"
`pragma protect key_keyname="MGC-VERIFSIM-RSA-1"
`pragma protect key_method="rsa"
`pragma protect key_block
O3SA0OCu5nuAjUUm9OZC+3rAeJsQazu1gZB0zy27DfSv6/+uzUX+j//p9FkEge0X
+yvO6iN66d6YGSEON+IrQCDGlz7D6Nz0G2BB5GNBlLakpl7LAIm+4ojkZdW5xgZm
V4RF9xBEHEnlg4R2hmsYA11tOdU4oLMecRMqx+fojc8=

`pragma protect data_method="aes128-cbc"
`pragma protect encoding=(enctype="base64", line_length=64, bytes=4528)
`pragma protect data_block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`pragma protect end_protected

endmodule
